﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Data.SqlClient
Imports System.Data

Public Class MainForm

    Protected dvProducts As DataView

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        LoadData()
    End Sub

    ''' <summary>
    ''' 显示一条状态消息，指出我们正试图连接 SQL Server。
    ''' 只有第一次尝试连接时，才需要显示此消息。
    ''' 确定已安装 SQL Express 或 SQL Server 后，
    ''' 不再需要显示此消息。
    ''' </summary>
    Private Sub LoadData()

        Dim frmStatusMessage As New Status()

        frmStatusMessage.Show("Connecting to SQL Server")

        Try
            Me.ProductsTableAdapter.Fill(Me.NorthwindDataSet.Products)

            '创建数据视图；使用构造函数指定
            '旨在提高性能的排序、筛选条件
            dvProducts = New DataView(Me.NorthwindDataSet.Products, "", "ProductName ASC", DataViewRowState.OriginalRows)
        Catch ex As Exception
            '无法连接 SQL Server 或 SQL Express
            frmStatusMessage.Close()
            Dim strMessage As String = "To run this sample, you must have SQL " & _
            "or SQL Express with the Northwind database installed.  " & _
            "To change the connection string, open the Settings Designer " & _
            "by double clicking on My Project in the Solution Explorer, " & _
            "select the Settings tab and change the value for the NorthwindConnectionString. " & vbCrLf & _
            " For instructions on installing SQL Express view ReadMe."
            MessageBox.Show(strMessage, "Bind Data to a ComboBox", MessageBoxButtons.OK, MessageBoxIcon.Information)
            '退出程序；无法连接 SQL Server 
            Application.Exit()
        End Try

        frmStatusMessage.Close()
    End Sub

    ''' <summary>
    ''' 绑定到表示颜色的字符串项的简单数组。
    ''' </summary>
    Private Sub btnArray_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnArray.Click
        Dim myColors() As String = {"AQUA", "BLACK", "BLUE", "GREEN", "RED", "WHITE", "YELLOW"}

        ComboBox1.DataSource = myColors
        ComboBox1.SelectedIndex = 0
        lblDataSource.Text = "Array"
    End Sub

    ''' <summary>
    ''' 绑定到简单数组列表，该数组列表具有用于不同形状的项。
    ''' </summary>
    Private Sub btnArrayList_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnArrayList.Click
        Dim myShapes As New ArrayList
        With myShapes
            .Add("Circle")
            .Add("Octagon")
            .Add("Rectangle")
            .Add("Squre")
            .Add("Trapezoid")
            .Add("Triange")
        End With

        ComboBox1.DataSource = myShapes
        ComboBox1.SelectedIndex = 0
        lblDataSource.Text = "ArrayList"
    End Sub

    ''' <summary>
    ''' 绑定到包含项的数组列表，这些项以
    ''' 为销售部门定义的结构为基础。
    ''' </summary>
    Private Sub btnArrayListA_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnArrayListA.Click

        Dim myDivisions As New ArrayList

        '向数组列表中添加部门结构项
        With myDivisions
            .Add(New Divisions("CENTRAL", 1))
            .Add(New Divisions("EAST", 2))
            .Add(New Divisions("NORTH", 3))
            .Add(New Divisions("SOUTH", 4))
        End With

        '将数组列表绑定到组合框
        With ComboBox1
            .DataSource = myDivisions
            .DisplayMember = "Name"
            .ValueMember = "Id"
        End With

        ComboBox1.SelectedIndex = 0
        lblDataSource.Text = "ArrayList - Advanced"
        lblAssocValue.Text = ComboBox1.SelectedValue.ToString
    End Sub

    ''' <summary>
    ''' 绑定到 Northwind 数据库的 products 表，该数据库
    ''' 已预先加载到 Northwind 数据集中。
    ''' 注意，该表尚未按任何特定顺序排序。
    ''' </summary>
    Private Sub btnDS_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDS.Click
        With ComboBox1
            .DataSource = Me.NorthwindDataSet.Products
            .DisplayMember = "ProductName"
            .ValueMember = "ProductID"
        End With

        ComboBox1.SelectedIndex = 0
        lblDataSource.Text = "DataSet"
        lblAssocValue.Text = ComboBox1.SelectedValue.ToString
    End Sub

    Private Sub btnDV_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDV.Click
        '绑定到 products 表根据产品名称列
        '按升序排列的排序视图。
        With ComboBox1
            .DataSource = dvProducts
            .DisplayMember = "ProductName"
            .ValueMember = "ProductID"
        End With

        ComboBox1.SelectedIndex = 0
        lblDataSource.Text = "DataView"
        lblAssocValue.Text = ComboBox1.SelectedValue.ToString
    End Sub

    ''' <summary>
    ''' 绑定到 BindingSource，后者绑定到 NorthwindDataset 的 Products 表。
    ''' </summary>
    Private Sub btnDC_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDC.Click
        With ComboBox1
            .DataSource = Me.ProductsBindingSource
            .DisplayMember = "ProductName"
            .ValueMember = "ProductID"
        End With

        ComboBox1.SelectedIndex = 0
        lblDataSource.Text = "BindingSource"
        lblAssocValue.Text = ComboBox1.SelectedValue.ToString
    End Sub

    Private Sub ComboBox1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ComboBox1.SelectedIndexChanged
        '为从组合框中选定的项显示关联值（如果有）。
        '若要确定某值是否可用，请检查组框的可见性。
        '在绑定过程中，如果该值不可用，代码会将此属性设置为 false；
        '如果该值可用，则将此属性设置为 true。
        If Me.ComboBox1.SelectedIndex >= 0 Then
            lblAssocValue.Text = ComboBox1.SelectedValue.ToString
        Else
            lblAssocValue.Text = "Nothing selected"
        End If
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub ProductsBindingNavigatorSaveItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ProductsBindingNavigatorSaveItem.Click
        Me.Validate()
        Me.ProductsBindingSource.EndEdit()
        Me.ProductsTableAdapter.Update(Me.NorthwindDataSet.Products)
    End Sub
End Class
